#version 150

#moj_import <light.glsl>
#moj_import <fog.glsl>
#moj_import <ortho_utils.glsl>
#moj_import <vertex_utils.glsl>
#moj_import <../config.txt>

in vec3 Position;
in vec4 Color;
in vec2 UV0;
in ivec2 UV2;
in vec3 Normal;

uniform sampler2D Sampler0;
uniform sampler2D Sampler2;

uniform mat4 ModelViewMat;
uniform mat4 ProjMat;
uniform vec3 ChunkOffset;
uniform float GameTime;
uniform int FogShape;
uniform float FogEnd;

out float vertexDistance;
out vec4 vertexColor;
out vec2 texCoord0;
out vec4 normal;

void main() {
    vec3 position = Position + ChunkOffset;
    texCoord0 = UV0;
	
	if (Waving_Features && Waving_Objects > 0) {
		int alpha = int(textureLod(Sampler0, UV0, 0).a * 255 + 0.5);
        position = wave_render(position, Waving_Objects, 4000 * GameTime, 0.5); //Tripwire
	}

    vertexColor = Color * minecraft_sample_lightmap(Sampler2, UV2);
	
    mat4 ViewMat = ProjMat;
	mat4 Camera = ModelViewMat;
	
	if (Orthographic) {
		ViewMat = getOrthoMat(ProjMat, 0.007);
		Camera = getIsometricViewMat(ModelViewMat);
	}
	
    vertexDistance = length((ModelViewMat * vec4(Position + ChunkOffset, 1.0)).xyz);
    gl_Position = ViewMat * Camera * vec4(position, 1.0);
}
