#version 150

#moj_import <fog.glsl>
#moj_import <fragment_utils.glsl>
#moj_import <../config.txt>

uniform sampler2D Sampler0;

uniform vec4 ColorModulator;
uniform vec4 FogColor;
uniform float FogStart;
uniform float FogEnd;

in float vertexDistance;
in vec4 vertexColor;
in vec4 lightColor;
in vec2 texCoord0;
flat in vec4 tint;

out vec4 fragColor;

void main() {
    vec4 color = texture(Sampler0, texCoord0) * vertexColor * ColorModulator;
    if (color.a < 0.1) discard; 

	if (Optifine == false && Potion_Variants) {
		if ((tint.a == 2 && round(color.a * 255) == 252) || tint.a != 2) color *= vec4(tint.rgb, 1);
		if (round(color.a * 255) == 251) discard;
	}
	
	if (Emissives) {
		float alpha = textureLod(Sampler0, texCoord0, 0.0).a * 255.0;
		color = make_emissive_item(color, lightColor, vertexDistance, alpha);
		color.a = remap_alpha(alpha) / 255.0;
	}
	
    fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);
}
