#version 150

#moj_import <light.glsl>
#moj_import <fog.glsl>
#moj_import <../config.txt>

in vec3 Position;
in vec4 Color;
in vec2 UV0;
in ivec2 UV1;
in ivec2 UV2;
in vec3 Normal;

uniform sampler2D Sampler0;
uniform sampler2D Sampler1;
uniform sampler2D Sampler2;

uniform mat4 ModelViewMat;
uniform mat4 ProjMat;
uniform mat3 IViewRotMat;
uniform int FogShape;
uniform float GameTime;

uniform vec3 Light0_Direction;
uniform vec3 Light1_Direction;

out float vertexDistance;
out vec4 vertexColor;
out vec4 lightMapColor;
out vec4 overlayColor;
out vec2 texCoord0;
out vec4 normal;

float hash(float p) {
    p = fract(p * 0.011);
    p *= p + 7.5;
    p *= p + p;
    return fract(p);
}

float noise(float x) {
    float i = floor(x);
    float f = fract(x);
    float u = f * f * (3.0 - 2.0 * f);
    return mix(hash(i), hash(i + 1.0), u);
}

float fbm(float x) {
    float v = 0.0;
    float a = 0.5;
    float shift = float(100);
    for (int i = 0; i < 3; ++i) {
        v += a * noise(x);
        x = x * 2.0 + shift;
        a *= 0.5;
    }
    return v;
}

int getDigit(int value, int n) {
    return (value / int(pow(10, n))) % 10;
}

void main() {
    vec3 position = IViewRotMat * Position;

    gl_Position = ProjMat * ModelViewMat * vec4(Position, 1.0);

    vertexColor = minecraft_mix_light(Light0_Direction, Light1_Direction, Normal, Color);
    lightMapColor = texelFetch(Sampler2, UV2 / 16, 0);
    vec4 damageFlash = texelFetch(Sampler1, UV1, 0);
    overlayColor = damageFlash;
    texCoord0 = UV0;
    normal = ProjMat * ModelViewMat * vec4(Normal, 0.0);
	
	vertexDistance = fog_distance(IViewRotMat * position, FogShape);
	
    if (Sodium == false && Player_Skin_Features && textureSize(Sampler0, 0) == ivec2(64, 64) && int(texelFetch(Sampler0, ivec2(63, 51), 0).a * 255.0 + 0.5) == 220 ) {
		ivec4 control = ivec4(texelFetch(Sampler0, ivec2(63, 50), 0).rgba * 255.0 + 0.5);
		vec3 blinkOffset = texelFetch(Sampler0, ivec2(20, 20), 0).rgb;
		
		if (Player_Blink_Face) {
			if (getDigit(control.r, 2) == 1 && damageFlash == vec4(1.0) && fbm(floor(GameTime * 6800.0 + dot(blinkOffset, vec3(0.01))) * 64.0) > 0.725 ) {
				if ( texCoord0.x >= 0.125 && texCoord0.y >= 0.125 && texCoord0.x <= 0.25 && texCoord0.y <= 0.25 ) {																			
					if (gl_VertexID == 12) { texCoord0 = vec2(0.125, 0.0); } 
				else if (gl_VertexID == 13) { texCoord0 = vec2(0.0, 0.0); } 
				else if (gl_VertexID == 14) { texCoord0 = vec2(0.0, 0.125); } 
				else if (gl_VertexID == 15) { texCoord0 = vec2(0.125, 0.125); } 
				} 
				if ( texCoord0.x >= 0.625 && texCoord0.y >= 0.125 && texCoord0.x <= 0.75 && texCoord0.y <= 0.25 ) {	
					if (gl_VertexID == 156) { texCoord0 = vec2(0.625, 0.0); } 
				else if (gl_VertexID == 157) { texCoord0 = vec2(0.5, 0.0); } 
				else if (gl_VertexID == 158) { texCoord0 = vec2(0.5, 0.125); } 
				else if (gl_VertexID == 159) { texCoord0 = vec2(0.625, 0.125); }
				}
			}
		}
		
		if (Player_Hurt_Face && getDigit(control.g, 2) == 1 && damageFlash != vec4(1.0) ) {
			if ( texCoord0.x >= 0.125 && texCoord0.y >= 0.125 && texCoord0.x <= 0.25 && texCoord0.y <= 0.25 ) {
				if (gl_VertexID == 12) { texCoord0 = vec2(0.5, 0.0); } 
			else if (gl_VertexID == 13) { texCoord0 = vec2(0.375, 0.0); } 
			else if (gl_VertexID == 14) { texCoord0 = vec2(0.375, 0.125); } 
			else if (gl_VertexID == 15) { texCoord0 = vec2(0.5, 0.125); }
			} 
			if ( texCoord0.x >= 0.625 && texCoord0.y >= 0.125 && texCoord0.x <= 0.75 && texCoord0.y <= 0.25 ) {
				if (gl_VertexID == 156) { texCoord0 = vec2(1.0, 0.0); } 
			else if (gl_VertexID == 157) { texCoord0 = vec2(0.875, 0.0); } 
			else if (gl_VertexID == 158) { texCoord0 = vec2(0.875, 0.125); } 
			else if (gl_VertexID == 159) { texCoord0 = vec2(1.0, 0.125); }
			}
		} 
		
		if (Player_Squint_Face && getDigit(control.b, 2) == 1 && damageFlash == vec4(1.0) && fbm(floor(GameTime * 6800.0 + dot(blinkOffset, vec3(0.01))) * 64.0) <= 0.725 && ( UV2.x >= 200 && UV2.x < 240 || UV2.x > 240 || UV2.x <= 50 && UV2.y <= 50 ) ) { 
			if (texCoord0.x >= 0.125 && texCoord0.y >= 0.125 && texCoord0.x <= 0.25 && texCoord0.y <= 0.25 ) {
				if (gl_VertexID == 12) { texCoord0 = vec2(1.0, 0.625); } 
			else if (gl_VertexID == 13) { texCoord0 = vec2(0.875, 0.625); } 
			else if (gl_VertexID == 14) { texCoord0 = vec2(0.875, 0.75); } 
			else if (gl_VertexID == 15) { texCoord0 = vec2(1.0, 0.75); }
			} 
			if ( texCoord0.x >= 0.625 && texCoord0.y >= 0.125 && texCoord0.x <= 0.75 && texCoord0.y <= 0.25 ) {
				if (gl_VertexID == 156) { texCoord0 = vec2(1.0, 0.5); } 
			else if (gl_VertexID == 157) { texCoord0 = vec2(0.875, 0.5); } 
			else if (gl_VertexID == 158) { texCoord0 = vec2(0.875, 0.625); } 
			else if (gl_VertexID == 159) { texCoord0 = vec2(1.0, 0.625); }
			}
		} 
		
		if (Player_Cape && getDigit(control.b, 0) == 1) {
			vec3 norm = IViewRotMat * Normal;
			float wave = (sin(GameTime * 1000.0) * 0.5 + 0.5) * 0.2;
			float angle = wave + 0.2;
			if (ivec4(texelFetch(Sampler0, ivec2(51, 19), 0) * 255.0 + 0.5) == ivec4(0, 0, 0, 255)) {
				if (gl_VertexID == 284) { texCoord0 = vec2(1.0, 0.25); position += norm * 0.045; }
				else if (gl_VertexID == 285) { texCoord0 = vec2(0.84375, 0.25); position += norm * 0.045; }
				else if (gl_VertexID == 286) { texCoord0 = vec2(0.84375, 0.5); position += norm * angle; position.y += length(angle) * 0.6 - 0.3; }
				else if (gl_VertexID == 287) { texCoord0 = vec2(1.0, 0.5); position += norm * angle; position.y += length(angle) * 0.6 - 0.3; }
			} else {
				if (gl_VertexID == 284) { texCoord0 = vec2(1.0, 0.25); position += norm * 0.045; }
				else if (gl_VertexID == 285) { texCoord0 = vec2(0.875, 0.25); position += norm * 0.045; }
				else if (gl_VertexID == 286) { texCoord0 = vec2(0.875, 0.5); position += norm * angle; position.y += length(angle) * 0.6 - 0.3; }
				else if (gl_VertexID == 287) { texCoord0 = vec2(1.0, 0.5); position += norm * angle; position.y += length(angle) * 0.6 - 0.3; }
			}
		}
		
		if (Player_Hurt_Mask) {
			overlayColor = texelFetch(Sampler0, ivec2(63, 51), 0);
			overlayColor.a = damageFlash.a;
		}
		
		gl_Position = ProjMat * ModelViewMat * vec4(position * IViewRotMat, 1.0);
		vertexDistance = fog_distance(position, FogShape);
    } 
}
