#version 150

#moj_import <fog.glsl>
#moj_import <fragment_utils.glsl>
#moj_import <../config.txt>

uniform sampler2D Sampler0;

uniform vec4 ColorModulator;
uniform vec4 FogColor;
uniform float GameTime;
uniform float FogStart;
uniform float FogEnd;

in float vertexDistance;
in vec4 vertexColor;
in vec4 lightColor;
in vec4 lightMapColor;
in vec4 overlayColor;
in vec2 texCoord0;
in vec4 texProj0;

out vec4 fragColor;

void main() {
    vec4 baseColor = texture(Sampler0, texCoord0) * vertexColor * ColorModulator;
    baseColor.rgb = mix(overlayColor.rgb, baseColor.rgb, overlayColor.a);
    vec4 color = baseColor * lightMapColor;

    if (Emissives == true) {
        float alpha = textureLod(Sampler0, texCoord0, 0.0).a * 255.0;
        color = make_emissive_entity(baseColor, lightColor, vertexDistance, alpha);
        color.a = remap_alpha(alpha) / 255.0;
    }

    if (color.a < 0.1) discard;
    fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);
}