#version 150

#moj_import <fog.glsl>
#moj_import <matrix.glsl>
#moj_import <fragment_utils.glsl>
#moj_import <../config.txt>

uniform sampler2D Sampler0;
uniform sampler2D Sampler1;

uniform vec4 ColorModulator;
uniform vec4 FogColor;
uniform float GameTime;
uniform float FogStart;
uniform float FogEnd;
uniform int EndPortalLayers;

in float vertexDistance;
in vec4 vertexColor;
in vec4 lightColor;
in vec4 lightMapColor;
in vec4 overlayColor;
in vec2 texCoord0;
in vec3 screenLocation;

out vec4 fragColor;


void main() {
    vec4 color = texture(Sampler0, texCoord0);
    color *= vertexColor * ColorModulator;
    color.rgb = mix(overlayColor.rgb, color.rgb, overlayColor.a);
	
	float alpha = textureLod(Sampler0, texCoord0, 0.0).a * 255.0;
    
    if (Optifine == false && Ender_Chest && int(alpha) == 251) {
        vec2 screenSize = gl_FragCoord.xy / (screenLocation.xy / screenLocation.z * 0.5 + 0.5);
        color.rgb = Endportal_Colors[0] * vec3(0.463, 0.337, 0.647);
        for (int i = 0; i < 16; i++) {
            vec4 proj = vec4(gl_FragCoord.xy / screenSize, 0, 1) * end_portal_layer(float(i + 1), GameTime);
            float pixel = hash12(floor(fract(proj.xy / proj.w) * 256.0));
            color.rgb += (step(0.95, pixel) * 0.2 + step(0.99, pixel) * 0.8) * (Endportal_Colors[i]);
        }
    }
    
	if (Emissives) {
		color = make_emissive_item(color, lightColor, vertexDistance, alpha);
		color.a = remap_alpha(alpha) / 255.0;
	} else { color *= lightMapColor; }

    if (color.a < 0.1) discard; 
    fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);
}