#version 150

#moj_import <light.glsl>
#moj_import <fog.glsl>
#moj_import <ortho_utils.glsl>
#moj_import <vertex_utils.glsl>
#moj_import <../config.txt>

in vec3 Position;
in vec4 Color;
in vec2 UV0;
in ivec2 UV2;
in vec3 Normal;

uniform sampler2D Sampler2;
uniform sampler2D Sampler0;

uniform mat4 ModelViewMat;
uniform mat4 ProjMat;
uniform vec3 ChunkOffset;
uniform float GameTime;
uniform int FogShape;
uniform float FogEnd;

out float vertexDistance;
out vec4 vertexColor;
out vec4 lightColor;
out vec2 texCoord0;

void main() {
    vec3 position = Position;
    texCoord0 = UV0;
    
    if (Chunk_Loading == 1.0) {
        float slide = chunkTranslate(ChunkOffset, FogEnd, ModelViewMat);
        position.y += slide * -800.0;
    }
	
	if (Chunk_Loading == 2.0) {
		vec4 normal = ProjMat * ModelViewMat * vec4(Normal, 0.0);
		float vertexId = mod(gl_VertexID, 4.0);
		vec3 fractPosition = fract(Position), absNormal = abs(Normal);
		if (absNormal.x == 1.0) { fractPosition *= rotationMatrix(Normal.zxy, -1.570796); 
		} else if (absNormal.y == 1.0) { fractPosition *= rotationMatrix(Normal.yzx, 1.570796); 
		} else if (Normal.z == -1.0) { fractPosition *= rotationMatrix(Normal.yzx, -3.14159);  }
		vec3 originOffset = vec3((fractPosition.x > 0.001 && fractPosition.x < 0.999) ? 0.5 - fractPosition.x : 0.5, (fractPosition.y > 0.001 && fractPosition.y < 0.999) ? 0.5 - fractPosition.y : 0.5, 0.0 );
		if ((vertexId == 0.0 && originOffset.y == 0.5) || (vertexId == 3.0 && originOffset.y == 0.5)) originOffset.y *= -1.0;
		if ((vertexId == 2.0 && originOffset.x == 0.5) || (vertexId == 3.0 && originOffset.x == 0.5)) originOffset.x *= -1.0;
		if (absNormal.x == 1.0) { originOffset *= rotationMatrix(Normal.zxy, 1.570796);
		} else if (absNormal.y == 1.0) { originOffset *= rotationMatrix(Normal.yzx, -1.570796);
		} else if (Normal.z == -1.0) { originOffset *= rotationMatrix(Normal.yzx, 3.14159); }
		float fadeAmount = pow(max(0.0, length((ModelViewMat * vec4(Position + originOffset + ChunkOffset, 1.0)).xyz) - (FogEnd - 16.0)), 2.0);
		float scale = clamp(fadeAmount * 0.075 / 16.0, 0.0, 1.0);
		position += scale * originOffset;
		gl_Position += normal * fadeAmount * (0.2 / 16.0 * 1.0 + 0.04);
		if (fadeAmount > 15.0 * 16.0) gl_Position = vec4(100.0, 100.0, 100.0, -1.0); 
    }
    
	position += ChunkOffset;
    
    if (Waving_Features) {
		int alpha = int(textureLod(Sampler0, UV0, 0).a * 255 + 0.5);
        int red = int(textureLod(Sampler0, UV0, 0).r * 255 + 0.5);
		
        if (Optifine == false && Waving_Foliage > 0) {
            float waveStrength = (alpha == 25 && red == 1) || alpha == 254 ? Waving_Foliage : //Vines
                                 (alpha == 25 && red == 2) || alpha == 253 ? Waving_Foliage * 0.5 : //Bushes, Dripleaf, & Chorus trees
                                 (alpha == 25 && red == 3) || alpha == 252 ? Waving_Foliage * 0.25 : 0.0; //Bamboo
            position = wave_render(position, waveStrength, 4000 * GameTime, 0.5);
        }
        
        if (Waving_Grass > 0 && ((alpha == 25 && red == 4) || alpha == 251)) position = wave_render(position, Waving_Grass, 4000 * GameTime, 0.5); //Grass, Crops & Flowers
        
        if (Waving_Fire > 0 && ((alpha == 25 && red == 5) || alpha == 249)) position = wave_render(position, Waving_Fire, 4000 * GameTime, 0.5); //Fire & Campfire
        
        if (Waving_Water > 0 && ((alpha == 25 && red == 6) || alpha == 248)) position = wave_render(position, Waving_Water * 1.5, 4000 * GameTime, 0.5); //Lily Pad & Underwater Foliage
        
        if (Waving_Objects > 0) {
            if ((alpha == 25 && red == 7) || alpha == 247) { position = wave_render(position, Waving_Objects, 4000 * GameTime, 0.2); } //Chains & Webs
			else if ((alpha == 25 && red == 8) || alpha == 246) { position = sway_render(position, Position, GameTime, ChunkOffset); } //Hanging Lanterns
        } 
        
        if (Spinning_Beacon && alpha == 245) position = orbital_render(position, Position, GameTime);
    }
	
    vertexColor = Color * minecraft_sample_lightmap(Sampler2, UV2);
        
    if (Emissives) {
        vertexColor = Color;
        lightColor = minecraft_sample_lightmap(Sampler2, UV2);
    }
	
    mat4 ViewMat = ProjMat;
	mat4 Camera = ModelViewMat;
	
	if (Orthographic) {
		ViewMat = getOrthoMat(ProjMat, 0.007);
		Camera = getIsometricViewMat(ModelViewMat);
	}
	
    vertexDistance = fog_distance(position, FogShape);
    gl_Position = ViewMat * Camera * vec4(position, 1.0);
}