#version 150

#moj_import <fog.glsl>
#moj_import <fragment_utils.glsl>
#moj_import <../config.txt>

uniform sampler2D Sampler0;

uniform vec4 ColorModulator;
uniform vec4 FogColor;
uniform float FogStart;
uniform float FogEnd;
uniform mat4 ModelViewMat;
uniform mat4 ProjMat;

in float vertexDistance;
in vec4 vertexColor;
in vec4 lightColor;
in vec2 texCoord0;

in vec4 position;
in vec4 glPos;

in vec2 uv1, uv2, inUV;
flat in vec2 uv3;

out vec4 fragColor;

void main() {
    vec4 color;
    color = texture(Sampler0, texCoord0) * vertexColor * ColorModulator;
	gl_FragDepth = gl_FragCoord.z;
	if (Cubic_Particles && position.w != 0) {
		vec3 dir = normalize((-glPos).xyz), rd = dir, ro = position.xyz, size = vec3(1.0 / 16.0), m = 1.0 / rd, n = m * ro, k = abs(m) * size, t1 = -n - k, t2 = -n + k;
		float tN = max(max(t1.x, t1.y), t1.z), tF = min(min(t2.x, t2.y), t2.z);
		if (tN > tF || tF < 0.0) discard;
		vec3 normal = -sign(rd) * step(t1.yzx, t1.xyz) * step(t1.zxy, t1.xyz), position = (ro + rd * tN) / size, sBoxResult = vec3(0.0, 0.0, tN);
		vec2 tex = (abs(normal.x) > 0.9) ? position.zy : (abs(normal.y) > 0.9) ? position.xz : position.xy, auv1 = round(uv1 / ((uv3.x == 0.0) ? (1.0 - inUV.x) : (1.0 - inUV.y))), auv2 = round(uv2 / ((uv3.x == 0.0) ? inUV.y : inUV.x));
		sBoxResult.xy = tex / 4.0 + 0.5;
		ivec2 res = ivec2(abs(auv1 - auv2)), stp = ivec2(min(auv1, auv2));
		color = texture(Sampler0, (stp + sBoxResult.xy * res) / textureSize(Sampler0, 0)) * vertexColor * ColorModulator;
		color.rgb *= dot(normal, vec3(0.34, -0.91, 0.23)) * 0.6 + 0.8;
		gl_FragDepth = (ProjMat * ModelViewMat * vec4(-dir * sBoxResult.z, 1.0)).z / (ProjMat * ModelViewMat * vec4(-dir * sBoxResult.z, 1.0)).w * 0.5 + 0.5;
	} else { if (color.a < 0.1) discard; }
	
	if (Emissives) {
		float alpha = textureLod(Sampler0, texCoord0, 0.0).a * 255.0;
		color = make_emissive(color, lightColor, vertexDistance, alpha);
	}
    
    fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);
}
