/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.EOFException;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.BufferedSource;
import okio.Okio;
import okio.Segment;
import okio.SegmentPool;
import okio.Source;
import okio.Timeout;

public final class InflaterSource
implements Source {
    private final BufferedSource source;
    private final Inflater inflater;
    private int bufferBytesHeldByInflater;
    private boolean closed;

    public InflaterSource(BufferedSource bufferedSource, Inflater inflater) {
        Intrinsics.checkNotNullParameter(bufferedSource, "source");
        Intrinsics.checkNotNullParameter(inflater, "inflater");
        this.source = bufferedSource;
        this.inflater = inflater;
    }

    public InflaterSource(Source source2, Inflater inflater) {
        Intrinsics.checkNotNullParameter(source2, "source");
        Intrinsics.checkNotNullParameter(inflater, "inflater");
        this(Okio.buffer(source2), inflater);
    }

    private final void releaseBytesAfterInflate() {
        int n = this.bufferBytesHeldByInflater;
        if (n == 0) {
            return;
        }
        InflaterSource inflaterSource = this;
        int n2 = n - this.inflater.getRemaining();
        inflaterSource.bufferBytesHeldByInflater -= n2;
        inflaterSource.source.skip(n2);
    }

    @Override
    public long read(Buffer buffer, long l) {
        block2: {
            Intrinsics.checkNotNullParameter(buffer, "sink");
            do {
                long l2;
                if ((l2 = this.readOrInflate(buffer, l)) > 0L) {
                    return l2;
                }
                if (this.inflater.finished() || this.inflater.needsDictionary()) break block2;
            } while (!this.source.exhausted());
            throw new EOFException("source exhausted prematurely");
        }
        return -1L;
    }

    /*
     * Unable to fully structure code
     */
    public final long readOrInflate(Buffer var1_2, long var2_3) {
        block14: {
            block15: {
                block13: {
                    Intrinsics.checkNotNullParameter(var1_2, "sink");
                    cfr_temp_0 = var2_3 - 0L;
                    var4_6 = cfr_temp_0 == 0L ? 0 : (cfr_temp_0 < 0L ? -1 : 1);
                    if (!(var4_6 >= 0)) break block14;
                    if (!(this.closed ^ true)) break block15;
                    if (var4_6 == false) {
                        return 0L;
                    }
                    try {
                        v0 = this;
                        v1 = v0;
                        v2 = v0;
                        v3 = var2_3;
                        var2_4 = var1_2.writableSegment$okio(1);
                    }
                    catch (DataFormatException var0_1) {
                        throw new IOException(var0_1);
                    }
                    v4 = 8192 - var2_4.limit;
                    var3_9 = (int)Math.min(v3, v4);
                    v1.refill();
                    v5 = v2.inflater;
                    v6 = var2_4;
                    v7 = v6;
                    var4_7 = v6.data;
                    var3_9 = v5.inflate(var4_7, v7.limit, var3_9);
                    super.releaseBytesAfterInflate();
                    if (var3_9 <= 0) ** GOTO lbl46
                    v8 = var3_9;
                    v9 = var1_2;
                    v10 = var2_4;
                    v11 = v10;
                    v12 = v10.limit;
                    v11.limit = v12 + var3_9;
                    var2_5 = v9.size();
                    var4_8 = v8;
                    var1_2.setSize$okio(var2_5 + var4_8);
                    return var4_8;
lbl46:
                    // 1 sources

                    if (var2_4.pos != var2_4.limit) break block13;
                    var1_2.head = var2_4.pop();
                    SegmentPool.recycle(var2_4);
                }
                return 0L;
            }
            throw new IllegalStateException("closed".toString());
        }
        this = "byteCount < 0: " + var2_3;
        throw new IllegalArgumentException(this.toString());
    }

    public final boolean refill() {
        int n;
        if (!((InflaterSource)((Object)segment)).inflater.needsInput()) {
            return false;
        }
        if (((InflaterSource)((Object)segment)).source.exhausted()) {
            return true;
        }
        InflaterSource inflaterSource = segment;
        Segment segment = inflaterSource.source.getBuffer().head;
        Intrinsics.checkNotNull(segment);
        int n2 = segment.pos;
        inflaterSource.bufferBytesHeldByInflater = n = segment.limit - n2;
        inflaterSource.inflater.setInput(segment.data, n2, n);
        return false;
    }

    @Override
    public Timeout timeout() {
        return this.source.timeout();
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        InflaterSource inflaterSource = this;
        inflaterSource.inflater.end();
        inflaterSource.closed = true;
        inflaterSource.source.close();
    }
}

