/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.typeUtil;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptorWithTypeParameters;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.types.DefinitelyNotNullType;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.StarProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributesKt;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutionKt;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.TypeWithEnhancementKt;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeChecker;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorType;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt$containsTypeAliasParameters$1;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt$requiresTypeAliasExpansion$1;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt$shouldBeUpdated$1;

public abstract class TypeUtilsKt {
    public static final KotlinBuiltIns getBuiltIns(KotlinType kotlinType) {
        KotlinType kotlinType2 = kotlinType;
        Intrinsics.checkNotNullParameter(kotlinType2, "<this>");
        KotlinBuiltIns kotlinBuiltIns = kotlinType2.getConstructor().getBuiltIns();
        Intrinsics.checkNotNullExpressionValue(kotlinBuiltIns, "constructor.builtIns");
        return kotlinBuiltIns;
    }

    public static final KotlinType makeNullable(KotlinType kotlinType) {
        KotlinType kotlinType2 = kotlinType;
        Intrinsics.checkNotNullParameter(kotlinType2, "<this>");
        KotlinType kotlinType3 = TypeUtils.makeNullable(kotlinType2);
        Intrinsics.checkNotNullExpressionValue(kotlinType3, "makeNullable(this)");
        return kotlinType3;
    }

    public static final KotlinType makeNotNullable(KotlinType kotlinType) {
        KotlinType kotlinType2 = kotlinType;
        Intrinsics.checkNotNullParameter(kotlinType2, "<this>");
        KotlinType kotlinType3 = TypeUtils.makeNotNullable(kotlinType2);
        Intrinsics.checkNotNullExpressionValue(kotlinType3, "makeNotNullable(this)");
        return kotlinType3;
    }

    public static final boolean isTypeParameter(KotlinType kotlinType) {
        KotlinType kotlinType2 = kotlinType;
        Intrinsics.checkNotNullParameter(kotlinType2, "<this>");
        return TypeUtils.isTypeParameter(kotlinType2);
    }

    public static final boolean isSubtypeOf(KotlinType kotlinType, KotlinType kotlinType2) {
        Intrinsics.checkNotNullParameter(kotlinType, "<this>");
        Intrinsics.checkNotNullParameter(kotlinType2, "superType");
        return KotlinTypeChecker.DEFAULT.isSubtypeOf(kotlinType, kotlinType2);
    }

    public static final KotlinType replaceAnnotations(KotlinType kotlinType, Annotations annotations2) {
        Intrinsics.checkNotNullParameter(kotlinType, "<this>");
        Intrinsics.checkNotNullParameter(annotations2, "newAnnotations");
        if (kotlinType.getAnnotations().isEmpty() && annotations2.isEmpty()) {
            return kotlinType;
        }
        return kotlinType.unwrap().replaceAttributes(TypeAttributesKt.replaceAnnotations(kotlinType.getAttributes(), annotations2));
    }

    public static final TypeProjection createProjection(KotlinType kotlinType, Variance variance, TypeParameterDescriptor typeParameterDescriptor) {
        TypeProjectionImpl typeProjectionImpl;
        Intrinsics.checkNotNullParameter(kotlinType, "type");
        Intrinsics.checkNotNullParameter((Object)variance, "projectionKind");
        if ((typeParameterDescriptor != null ? typeParameterDescriptor.getVariance() : null) == variance) {
            variance = Variance.INVARIANT;
        }
        TypeProjectionImpl typeProjectionImpl2 = typeProjectionImpl;
        typeProjectionImpl2(variance, kotlinType);
        return typeProjectionImpl2;
    }

    public static final TypeProjection asTypeProjection(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter(kotlinType, "<this>");
        return new TypeProjectionImpl(kotlinType);
    }

    public static final boolean contains(KotlinType kotlinType, Function1 function1) {
        Function1 function12 = function1;
        Intrinsics.checkNotNullParameter(kotlinType, "<this>");
        Intrinsics.checkNotNullParameter(function12, "predicate");
        return TypeUtils.contains(kotlinType, function12);
    }

    public static final KotlinType replaceArgumentsWithStarProjections(KotlinType kotlinType) {
        block11: {
            UnwrappedType unwrappedType;
            block10: {
                block9: {
                    TypeParameterDescriptor typeParameterDescriptor;
                    ArrayList<StarProjectionImpl> arrayList;
                    Iterator iterator2;
                    KotlinType kotlinType2 = kotlinType;
                    Intrinsics.checkNotNullParameter(kotlinType2, "<this>");
                    kotlinType = kotlinType2.unwrap();
                    if (!(kotlinType instanceof FlexibleType)) break block9;
                    unwrappedType = (FlexibleType)kotlinType;
                    SimpleType simpleType2 = ((FlexibleType)unwrappedType).getLowerBound();
                    if (!simpleType2.getConstructor().getParameters().isEmpty() && simpleType2.getConstructor().getDeclarationDescriptor() != null) {
                        ArrayList<StarProjectionImpl> arrayList2;
                        iterator2 = simpleType2.getConstructor().getParameters();
                        Intrinsics.checkNotNullExpressionValue(iterator2, "constructor.parameters");
                        arrayList = arrayList2;
                        arrayList2 = new ArrayList<StarProjectionImpl>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator2), 10));
                        iterator2 = iterator2.iterator();
                        while (iterator2.hasNext()) {
                            typeParameterDescriptor = (TypeParameterDescriptor)iterator2.next();
                            arrayList.add(new StarProjectionImpl(typeParameterDescriptor));
                        }
                        simpleType2 = TypeSubstitutionKt.replace$default(simpleType2, arrayList, null, 2, null);
                    }
                    if (!(unwrappedType = ((FlexibleType)unwrappedType).getUpperBound()).getConstructor().getParameters().isEmpty() && unwrappedType.getConstructor().getDeclarationDescriptor() != null) {
                        ArrayList<StarProjectionImpl> arrayList3;
                        iterator2 = unwrappedType.getConstructor().getParameters();
                        Intrinsics.checkNotNullExpressionValue(iterator2, "constructor.parameters");
                        arrayList = arrayList3;
                        arrayList3 = new ArrayList<StarProjectionImpl>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator2), 10));
                        iterator2 = iterator2.iterator();
                        while (iterator2.hasNext()) {
                            typeParameterDescriptor = (TypeParameterDescriptor)iterator2.next();
                            arrayList.add(new StarProjectionImpl(typeParameterDescriptor));
                        }
                        unwrappedType = TypeSubstitutionKt.replace$default((SimpleType)unwrappedType, arrayList, null, 2, null);
                    }
                    unwrappedType = KotlinTypeFactory.flexibleType(simpleType2, (SimpleType)unwrappedType);
                    break block10;
                }
                if (!(kotlinType instanceof SimpleType)) break block11;
                unwrappedType = (SimpleType)kotlinType;
                if (!unwrappedType.getConstructor().getParameters().isEmpty() && unwrappedType.getConstructor().getDeclarationDescriptor() != null) {
                    ArrayList<StarProjectionImpl> arrayList;
                    Object object = unwrappedType.getConstructor().getParameters();
                    Intrinsics.checkNotNullExpressionValue(object, "constructor.parameters");
                    ArrayList<StarProjectionImpl> arrayList4 = arrayList;
                    arrayList = new ArrayList<StarProjectionImpl>(CollectionsKt.collectionSizeOrDefault((Iterable)object, 10));
                    object = object.iterator();
                    while (object.hasNext()) {
                        TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)object.next();
                        arrayList4.add(new StarProjectionImpl(typeParameterDescriptor));
                    }
                    unwrappedType = TypeSubstitutionKt.replace$default((SimpleType)unwrappedType, arrayList4, null, 2, null);
                }
            }
            return TypeWithEnhancementKt.inheritEnhancement(unwrappedType, kotlinType);
        }
        throw new NoWhenBranchMatchedException();
    }

    public static final Set extractTypeParametersFromUpperBounds(KotlinType kotlinType, Set set) {
        LinkedHashSet linkedHashSet;
        Intrinsics.checkNotNullParameter(kotlinType, "<this>");
        LinkedHashSet linkedHashSet2 = linkedHashSet;
        linkedHashSet2();
        TypeUtilsKt.extractTypeParametersFromUpperBounds(kotlinType, kotlinType, linkedHashSet2, set);
        return linkedHashSet;
    }

    private static final void extractTypeParametersFromUpperBounds(KotlinType iterator2, KotlinType kotlinType, Set set, Set set2) {
        Object object = ((KotlinType)((Object)iterator2)).getConstructor().getDeclarationDescriptor();
        if (object instanceof TypeParameterDescriptor) {
            if (!Intrinsics.areEqual(((KotlinType)((Object)iterator2)).getConstructor(), kotlinType.getConstructor())) {
                set.add(object);
            } else {
                for (KotlinType kotlinType2 : ((TypeParameterDescriptor)object).getUpperBounds()) {
                    Intrinsics.checkNotNullExpressionValue(kotlinType2, "upperBound");
                    TypeUtilsKt.extractTypeParametersFromUpperBounds(kotlinType2, kotlinType, set, set2);
                }
            }
        } else {
            object = ((KotlinType)((Object)iterator2)).getConstructor().getDeclarationDescriptor();
            object = object instanceof ClassifierDescriptorWithTypeParameters ? (ClassifierDescriptorWithTypeParameters)object : null;
            object = object != null ? object.getDeclaredTypeParameters() : null;
            iterator2 = ((KotlinType)((Object)iterator2)).getArguments().iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int n2 = n + 1;
                TypeProjection typeProjection = (TypeProjection)iterator2.next();
                TypeParameterDescriptor typeParameterDescriptor = object != null ? (TypeParameterDescriptor)CollectionsKt.getOrNull((List)object, n) : null;
                if (!(typeParameterDescriptor != null && set2 != null && set2.contains(typeParameterDescriptor) || typeProjection.isStarProjection() || CollectionsKt.contains(set, typeProjection.getType().getConstructor().getDeclarationDescriptor()) || Intrinsics.areEqual(typeProjection.getType().getConstructor(), kotlinType.getConstructor()))) {
                    KotlinType kotlinType3 = typeProjection.getType();
                    Intrinsics.checkNotNullExpressionValue(kotlinType3, "argument.type");
                    TypeUtilsKt.extractTypeParametersFromUpperBounds(kotlinType3, kotlinType, set, set2);
                }
                n = n2;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean hasTypeParameterRecursiveBounds(TypeParameterDescriptor typeParameterDescriptor, TypeConstructor typeConstructor2, Set set) {
        boolean bl;
        TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor;
        Intrinsics.checkNotNullParameter(typeParameterDescriptor2, "typeParameter");
        Object object = typeParameterDescriptor2.getUpperBounds();
        Intrinsics.checkNotNullExpressionValue(object, "typeParameter.upperBounds");
        if (object instanceof Collection && object.isEmpty()) {
            return false;
        }
        object = object.iterator();
        do {
            if (!object.hasNext()) return false;
            KotlinType kotlinType = (KotlinType)object.next();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "upperBound");
            if (TypeUtilsKt.containsSelfTypeParameter(kotlinType, typeParameterDescriptor.getDefaultType().getConstructor(), set)) {
                if (typeConstructor2 == null) return true;
                if (Intrinsics.areEqual(kotlinType.getConstructor(), typeConstructor2)) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    public static /* synthetic */ boolean hasTypeParameterRecursiveBounds$default(TypeParameterDescriptor typeParameterDescriptor, TypeConstructor typeConstructor2, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            typeConstructor2 = null;
        }
        if ((n & 4) != 0) {
            set = null;
        }
        return TypeUtilsKt.hasTypeParameterRecursiveBounds(typeParameterDescriptor, typeConstructor2, set);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean containsSelfTypeParameter(KotlinType iterator2, TypeConstructor typeConstructor2, Set set) {
        boolean bl;
        if (Intrinsics.areEqual(((KotlinType)((Object)iterator2)).getConstructor(), typeConstructor2)) {
            return true;
        }
        Object object = ((KotlinType)((Object)iterator2)).getConstructor().getDeclarationDescriptor();
        object = object instanceof ClassifierDescriptorWithTypeParameters ? (ClassifierDescriptorWithTypeParameters)object : null;
        object = object != null ? object.getDeclaredTypeParameters() : null;
        if ((iterator2 = CollectionsKt.withIndex(((KotlinType)((Object)iterator2)).getArguments())) instanceof Collection && ((Collection)((Object)iterator2)).isEmpty()) {
            return false;
        }
        iterator2 = iterator2.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            IndexedValue indexedValue = (IndexedValue)iterator2.next();
            int n = indexedValue.component1();
            TypeProjection typeProjection = (TypeProjection)indexedValue.component2();
            TypeParameterDescriptor typeParameterDescriptor = object != null ? (TypeParameterDescriptor)CollectionsKt.getOrNull((List)object, n) : null;
            if (!(typeParameterDescriptor != null && set != null && set.contains(typeParameterDescriptor)) && !typeProjection.isStarProjection()) {
                KotlinType kotlinType = typeProjection.getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType, "argument.type");
                bl = TypeUtilsKt.containsSelfTypeParameter(kotlinType, typeConstructor2, set);
                continue;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    public static final KotlinType replaceArgumentsWithStarProjectionOrMapped(KotlinType kotlinType, TypeSubstitutor typeSubstitutor2, Map map, Variance variance, Set set) {
        block15: {
            UnwrappedType unwrappedType;
            block14: {
                block13: {
                    TypeProjection typeProjection;
                    TypeParameterDescriptor typeParameterDescriptor;
                    ArrayList<TypeProjection> arrayList;
                    Iterator iterator2;
                    Intrinsics.checkNotNullParameter(kotlinType, "<this>");
                    Intrinsics.checkNotNullParameter(typeSubstitutor2, "substitutor");
                    Intrinsics.checkNotNullParameter(map, "substitutionMap");
                    Intrinsics.checkNotNullParameter((Object)variance, "variance");
                    unwrappedType = kotlinType.unwrap();
                    if (!(unwrappedType instanceof FlexibleType)) break block13;
                    UnwrappedType unwrappedType2 = (FlexibleType)unwrappedType;
                    SimpleType simpleType2 = ((FlexibleType)unwrappedType2).getLowerBound();
                    if (!simpleType2.getConstructor().getParameters().isEmpty() && simpleType2.getConstructor().getDeclarationDescriptor() != null) {
                        ArrayList<TypeProjection> arrayList2;
                        iterator2 = simpleType2.getConstructor().getParameters();
                        Intrinsics.checkNotNullExpressionValue(iterator2, "constructor.parameters");
                        arrayList = arrayList2;
                        arrayList2 = new ArrayList<TypeProjection>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator2), 10));
                        iterator2 = iterator2.iterator();
                        while (iterator2.hasNext()) {
                            typeParameterDescriptor = (TypeParameterDescriptor)iterator2.next();
                            typeProjection = (TypeProjection)CollectionsKt.getOrNull(kotlinType.getArguments(), typeParameterDescriptor.getIndex());
                            if (set != null && set.contains(typeParameterDescriptor) || typeProjection == null || !map.containsKey(typeProjection.getType().getConstructor())) {
                                StarProjectionImpl starProjectionImpl;
                                typeProjection = starProjectionImpl;
                                starProjectionImpl = new StarProjectionImpl(typeParameterDescriptor);
                            }
                            arrayList.add(typeProjection);
                        }
                        simpleType2 = TypeSubstitutionKt.replace$default(simpleType2, arrayList, null, 2, null);
                    }
                    if (!(unwrappedType2 = ((FlexibleType)unwrappedType2).getUpperBound()).getConstructor().getParameters().isEmpty() && unwrappedType2.getConstructor().getDeclarationDescriptor() != null) {
                        ArrayList<TypeProjection> arrayList3;
                        iterator2 = unwrappedType2.getConstructor().getParameters();
                        Intrinsics.checkNotNullExpressionValue(iterator2, "constructor.parameters");
                        arrayList = arrayList3;
                        arrayList3 = new ArrayList<TypeProjection>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator2), 10));
                        iterator2 = iterator2.iterator();
                        while (iterator2.hasNext()) {
                            typeParameterDescriptor = (TypeParameterDescriptor)iterator2.next();
                            typeProjection = (TypeProjection)CollectionsKt.getOrNull(kotlinType.getArguments(), typeParameterDescriptor.getIndex());
                            if (set != null && set.contains(typeParameterDescriptor) || typeProjection == null || !map.containsKey(typeProjection.getType().getConstructor())) {
                                StarProjectionImpl starProjectionImpl;
                                typeProjection = starProjectionImpl;
                                starProjectionImpl = new StarProjectionImpl(typeParameterDescriptor);
                            }
                            arrayList.add(typeProjection);
                        }
                        unwrappedType2 = TypeSubstitutionKt.replace$default((SimpleType)unwrappedType2, arrayList, null, 2, null);
                    }
                    kotlinType = KotlinTypeFactory.flexibleType(simpleType2, (SimpleType)unwrappedType2);
                    break block14;
                }
                if (!(unwrappedType instanceof SimpleType)) break block15;
                SimpleType simpleType3 = (SimpleType)unwrappedType;
                if (!simpleType3.getConstructor().getParameters().isEmpty() && simpleType3.getConstructor().getDeclarationDescriptor() != null) {
                    ArrayList<TypeProjection> arrayList;
                    Object object = simpleType3.getConstructor().getParameters();
                    Intrinsics.checkNotNullExpressionValue(object, "constructor.parameters");
                    ArrayList<TypeProjection> arrayList4 = arrayList;
                    arrayList = new ArrayList<TypeProjection>(CollectionsKt.collectionSizeOrDefault((Iterable)object, 10));
                    object = object.iterator();
                    while (object.hasNext()) {
                        TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)object.next();
                        TypeProjection typeProjection = (TypeProjection)CollectionsKt.getOrNull(kotlinType.getArguments(), typeParameterDescriptor.getIndex());
                        if (set != null && set.contains(typeParameterDescriptor) || typeProjection == null || !map.containsKey(typeProjection.getType().getConstructor())) {
                            StarProjectionImpl starProjectionImpl;
                            typeProjection = starProjectionImpl;
                            starProjectionImpl = new StarProjectionImpl(typeParameterDescriptor);
                        }
                        arrayList4.add(typeProjection);
                    }
                    kotlinType = TypeSubstitutionKt.replace$default(simpleType3, arrayList4, null, 2, null);
                } else {
                    kotlinType = simpleType3;
                }
            }
            KotlinType kotlinType2 = typeSubstitutor2.safeSubstitute(TypeWithEnhancementKt.inheritEnhancement((UnwrappedType)kotlinType, unwrappedType), variance);
            Intrinsics.checkNotNullExpressionValue(kotlinType2, "replaceArgumentsByParame\u2026ubstitute(it, variance) }");
            return kotlinType2;
        }
        throw new NoWhenBranchMatchedException();
    }

    public static final boolean containsTypeAliasParameters(KotlinType kotlinType) {
        KotlinType kotlinType2 = kotlinType;
        Intrinsics.checkNotNullParameter(kotlinType2, "<this>");
        return TypeUtilsKt.contains(kotlinType2, TypeUtilsKt$containsTypeAliasParameters$1.INSTANCE);
    }

    public static final boolean isTypeAliasParameter(ClassifierDescriptor classifierDescriptor) {
        ClassifierDescriptor classifierDescriptor2 = classifierDescriptor;
        Intrinsics.checkNotNullParameter(classifierDescriptor2, "<this>");
        return classifierDescriptor2 instanceof TypeParameterDescriptor && ((TypeParameterDescriptor)classifierDescriptor).getContainingDeclaration() instanceof TypeAliasDescriptor;
    }

    public static final boolean requiresTypeAliasExpansion(KotlinType kotlinType) {
        KotlinType kotlinType2 = kotlinType;
        Intrinsics.checkNotNullParameter(kotlinType2, "<this>");
        return TypeUtilsKt.contains(kotlinType2, TypeUtilsKt$requiresTypeAliasExpansion$1.INSTANCE);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final KotlinType getRepresentativeUpperBound(TypeParameterDescriptor object) {
        Object var2_3;
        block2: {
            Object object2 = object;
            Intrinsics.checkNotNullParameter(object2, "<this>");
            List list = object2.getUpperBounds();
            Intrinsics.checkNotNullExpressionValue(list, "upperBounds");
            boolean bl = list.isEmpty() ^ true;
            if (_Assertions.ENABLED && !bl) {
                object = "Upper bounds should not be empty: " + object;
                throw new AssertionError(object);
            }
            List list2 = object.getUpperBounds();
            Intrinsics.checkNotNullExpressionValue(list2, "upperBounds");
            for (Object t : list2) {
                var2_3 = t;
                ClassifierDescriptor classifierDescriptor = ((KotlinType)t).getConstructor().getDeclarationDescriptor();
                classifierDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
                if (!(classifierDescriptor != null && classifierDescriptor.getKind() != ClassKind.INTERFACE && classifierDescriptor.getKind() != ClassKind.ANNOTATION_CLASS)) continue;
                break block2;
            }
            var2_3 = null;
        }
        KotlinType kotlinType = var2_3;
        if (kotlinType != null) return kotlinType;
        List list = object.getUpperBounds();
        Intrinsics.checkNotNullExpressionValue(list, "upperBounds");
        Object object3 = CollectionsKt.first(list);
        Intrinsics.checkNotNullExpressionValue(object3, "upperBounds.first()");
        return (KotlinType)object3;
    }

    public static final boolean shouldBeUpdated(KotlinType kotlinType) {
        return kotlinType == null || TypeUtilsKt.contains(kotlinType, TypeUtilsKt$shouldBeUpdated$1.INSTANCE);
    }

    public static final boolean isStubType(KotlinType kotlinType) {
        KotlinType kotlinType2 = kotlinType;
        Intrinsics.checkNotNullParameter(kotlinType2, "<this>");
        if (kotlinType2 instanceof DefinitelyNotNullType) {
            ((DefinitelyNotNullType)kotlinType).getOriginal();
        }
        return false;
    }

    public static final boolean isStubTypeForBuilderInference(KotlinType kotlinType) {
        KotlinType kotlinType2 = kotlinType;
        Intrinsics.checkNotNullParameter(kotlinType2, "<this>");
        if (kotlinType2 instanceof DefinitelyNotNullType) {
            ((DefinitelyNotNullType)kotlinType).getOriginal();
        }
        return false;
    }

    public static final boolean isUnresolvedType(KotlinType kotlinType) {
        KotlinType kotlinType2 = kotlinType;
        Intrinsics.checkNotNullParameter(kotlinType2, "type");
        return kotlinType2 instanceof ErrorType && ((ErrorType)kotlinType).getKind().isUnresolved();
    }

    public static final boolean hasTypeParameterRecursiveBounds(TypeParameterDescriptor typeParameterDescriptor) {
        TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor;
        Intrinsics.checkNotNullParameter(typeParameterDescriptor2, "typeParameter");
        return TypeUtilsKt.hasTypeParameterRecursiveBounds$default(typeParameterDescriptor2, null, null, 6, null);
    }
}

