/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.jvm;

import java.util.Collection;
import java.util.Iterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.InlineClassesUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;

public abstract class InlineClassManglingRulesKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean shouldHideConstructorDueToInlineClassTypeValueParameters(CallableMemberDescriptor iterator2) {
        KotlinType kotlinType;
        Iterator iterator3 = iterator2;
        Intrinsics.checkNotNullParameter(iterator3, "descriptor");
        if (!(iterator3 instanceof ClassConstructorDescriptor)) return false;
        iterator2 = (ClassConstructorDescriptor)((Object)iterator2);
        if (iterator2 == null) {
            return false;
        }
        if (DescriptorVisibilities.isPrivate(iterator2.getVisibility())) {
            return false;
        }
        ClassDescriptor classDescriptor = iterator2.getConstructedClass();
        Intrinsics.checkNotNullExpressionValue(classDescriptor, "constructorDescriptor.constructedClass");
        if (InlineClassesUtilsKt.isInlineClass(classDescriptor)) {
            return false;
        }
        if (DescriptorUtils.isSealedClass(iterator2.getConstructedClass())) {
            return false;
        }
        iterator2 = iterator2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(iterator2, "constructorDescriptor.valueParameters");
        if (iterator2 instanceof Collection && iterator2.isEmpty()) {
            return false;
        }
        iterator2 = iterator2.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            kotlinType = ((ValueParameterDescriptor)iterator2.next()).getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "it.type");
        } while (!InlineClassManglingRulesKt.requiresFunctionNameManglingInParameterTypes(kotlinType));
        return true;
    }

    public static final boolean isInlineClassThatRequiresMangling(DeclarationDescriptor declarationDescriptor) {
        DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
        Intrinsics.checkNotNullParameter(declarationDescriptor2, "<this>");
        return InlineClassesUtilsKt.isInlineClass(declarationDescriptor2) && !InlineClassManglingRulesKt.isDontMangleClass((ClassDescriptor)declarationDescriptor);
    }

    public static final boolean isInlineClassThatRequiresMangling(KotlinType annotated) {
        KotlinType kotlinType = annotated;
        Intrinsics.checkNotNullParameter(kotlinType, "<this>");
        annotated = kotlinType.getConstructor().getDeclarationDescriptor();
        return annotated != null && InlineClassManglingRulesKt.isInlineClassThatRequiresMangling((DeclarationDescriptor)annotated);
    }

    private static final boolean requiresFunctionNameManglingInParameterTypes(KotlinType kotlinType) {
        return InlineClassManglingRulesKt.isInlineClassThatRequiresMangling(kotlinType) || InlineClassManglingRulesKt.isTypeParameterWithUpperBoundThatRequiresMangling(kotlinType);
    }

    private static final boolean isDontMangleClass(ClassDescriptor classDescriptor) {
        return Intrinsics.areEqual(DescriptorUtilsKt.getFqNameSafe(classDescriptor), StandardNames.RESULT_FQ_NAME);
    }

    private static final boolean isTypeParameterWithUpperBoundThatRequiresMangling(KotlinType annotated) {
        if ((annotated = (annotated = annotated.getConstructor().getDeclarationDescriptor()) instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)annotated : null) == null) {
            return false;
        }
        return InlineClassManglingRulesKt.requiresFunctionNameManglingInParameterTypes(TypeUtilsKt.getRepresentativeUpperBound((TypeParameterDescriptor)annotated));
    }
}

